import { Message, Comment, ChannelStats, User, UserPermissions } from "../types";

export const mockMessages: Message[] = [
  {
    id: '1',
    channelType: 'trendyol-product',
    channelName: 'Trendyol',
    channelCategory: 'Ürün Sorusu',
    customerName: 'Ahmet Yılmaz',
    lastMessage: 'Bu ürünün kargo ücreti var mı?',
    timestamp: new Date(Date.now() - 5 * 60000),
    unread: 2,
    conversation: [
      {
        id: 'c1-1',
        sender: 'customer',
        content: 'Merhaba, bu ürünün kargo ücreti var mı?',
        timestamp: new Date(Date.now() - 5 * 60000),
      },
    ],
    context: {
      productInfo: {
        imageUrl: 'https://images.unsplash.com/photo-1631984564919-1f6b2313a71c?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
        name: 'Nike Air Max 270 Erkek Spor Ayakkabı',
        stockCode: 'NK-AM270-BK-42',
        brand: 'Nike',
      },
    },
  },
  {
    id: '2',
    channelType: 'trendyol-order',
    channelName: 'Trendyol',
    channelCategory: 'Sipariş Sorusu',
    customerName: 'Zeynep Demir',
    lastMessage: 'Siparişim ne zaman gelecek?',
    timestamp: new Date(Date.now() - 15 * 60000),
    unread: 1,
    conversation: [
      {
        id: 'c2-1',
        sender: 'customer',
        content: 'Siparişim ne zaman gelecek? Sipariş numaram: TR123456',
        timestamp: new Date(Date.now() - 15 * 60000),
      },
    ],
    context: {
      orderInfo: {
        orderNumber: 'TR-2024-123456',
        orderDate: new Date(Date.now() - 3 * 24 * 60 * 60000), // 3 gün önce
      },
    },
  },
  {
    id: '3',
    channelType: 'instagram-message',
    channelName: 'Instagram',
    channelCategory: 'Gelen Mesaj',
    customerName: 'Mehmet Kaya',
    lastMessage: 'Story\'nizde gördüğüm ürünü satın almak istiyorum',
    timestamp: new Date(Date.now() - 25 * 60000),
    unread: 0,
    conversation: [
      {
        id: 'c3-1',
        sender: 'customer',
        content: 'Story\'nizde gördüğüm ürünü satın almak istiyorum',
        timestamp: new Date(Date.now() - 25 * 60000),
      },
      {
        id: 'c3-2',
        sender: 'agent',
        content: 'Merhaba! Hangi ürünle ilgileniyorsunuz?',
        timestamp: new Date(Date.now() - 20 * 60000),
      },
    ],
  },
  {
    id: '4',
    channelType: 'facebook-message',
    channelName: 'Facebook',
    channelCategory: 'Gelen Mesaj',
    customerName: 'Ayşe Şahin',
    lastMessage: 'Kampanya hakkında bilgi alabilir miyim?',
    timestamp: new Date(Date.now() - 45 * 60000),
    unread: 1,
    conversation: [
      {
        id: 'c4-1',
        sender: 'customer',
        content: 'Kampanya hakkında bilgi alabilir miyim?',
        timestamp: new Date(Date.now() - 45 * 60000),
      },
    ],
  },
  {
    id: '5',
    channelType: 'whatsapp',
    channelName: 'WhatsApp',
    channelCategory: '+90555 555 55 55',
    customerName: 'Can Öztürk',
    lastMessage: 'Ürün iadesi yapmak istiyorum',
    timestamp: new Date(Date.now() - 60 * 60000),
    unread: 2,
    conversation: [
      {
        id: 'c5-1',
        sender: 'customer',
        content: 'Merhaba, aldığım ürünü iade etmek istiyorum',
        timestamp: new Date(Date.now() - 70 * 60000),
      },
      {
        id: 'c5-2',
        sender: 'agent',
        content: 'Tabii ki yardımcı olabilirim. Sipariş numaranızı alabilir miyim?',
        timestamp: new Date(Date.now() - 65 * 60000),
      },
      {
        id: 'c5-3',
        sender: 'customer',
        content: 'Ürün iadesi yapmak istiyorum',
        timestamp: new Date(Date.now() - 60 * 60000),
      },
    ],
  },
  {
    id: '6',
    channelType: 'email',
    channelName: 'E-posta',
    channelCategory: 'info@test.com',
    customerName: 'Elif Yıldız',
    lastMessage: 'Toplu sipariş için fiyat teklifi',
    timestamp: new Date(Date.now() - 90 * 60000),
    unread: 0,
    conversation: [
      {
        id: 'c6-1',
        sender: 'customer',
        content: 'Merhaba, 100 adet ürün için toplu fiyat alabilir miyim?',
        timestamp: new Date(Date.now() - 90 * 60000),
      },
      {
        id: 'c6-2',
        sender: 'agent',
        content: 'Merhaba, toplu siparişler için özel fiyat sunuyoruz. Detayları mail ile göndereceğim.',
        timestamp: new Date(Date.now() - 85 * 60000),
      },
    ],
  },
  {
    id: '7',
    channelType: 'ticimax',
    channelName: 'Ticimax',
    channelCategory: 'Destek Talebi',
    customerName: 'Ali Demir',
    lastMessage: 'Ödeme sayfasında hata alıyorum',
    timestamp: new Date(Date.now() - 120 * 60000),
    unread: 3,
    conversation: [
      {
        id: 'c7-1',
        sender: 'customer',
        content: 'Ödeme yaparken sürekli hata alıyorum, yardımcı olur musunuz?',
        timestamp: new Date(Date.now() - 120 * 60000),
      },
    ],
    context: {
      ticketInfo: {
        title: 'Ödeme sayfasında hata alıyorum',
        date: new Date(Date.now() - 120 * 60000),
      },
    },
  },
  {
    id: '8',
    channelType: 'hepsiburada-product',
    channelName: 'Hepsiburada',
    channelCategory: 'Ürün Sorusu',
    customerName: 'Fatma Arslan',
    lastMessage: 'Bu ürünün garantisi var mı?',
    timestamp: new Date(Date.now() - 150 * 60000),
    unread: 1,
    conversation: [
      {
        id: 'c8-1',
        sender: 'customer',
        content: 'Bu ürünün garantisi var mı? Kaç yıl?',
        timestamp: new Date(Date.now() - 150 * 60000),
      },
    ],
    context: {
      productInfo: {
        imageUrl: 'https://images.unsplash.com/photo-1736616967588-d81fcd6f4d0a?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
        name: 'MacBook Pro 16" M3 Max 16GB RAM 512GB SSD',
        stockCode: 'APPLE-MBP16-M3-512',
        brand: 'Apple',
      },
    },
  },
  {
    id: '9',
    channelType: 'hepsiburada-order',
    channelName: 'Hepsiburada',
    channelCategory: 'Sipariş Sorusu',
    customerName: 'Burak Yılmaz',
    lastMessage: 'Kargom nerede?',
    timestamp: new Date(Date.now() - 180 * 60000),
    unread: 0,
    conversation: [
      {
        id: 'c9-1',
        sender: 'customer',
        content: 'Kargom nerede? 3 gündür bekliyorum.',
        timestamp: new Date(Date.now() - 180 * 60000),
      },
      {
        id: 'c9-2',
        sender: 'agent',
        content: 'Hemen kontrol ediyorum, sipariş numaranızı alabilir miyim?',
        timestamp: new Date(Date.now() - 175 * 60000),
      },
    ],
    context: {
      orderInfo: {
        orderNumber: 'HB-2024-789012',
        orderDate: new Date(Date.now() - 5 * 24 * 60 * 60000), // 5 gün önce
      },
    },
  },
];

export const mockComments: Comment[] = [
  {
    id: 'cm1',
    channelType: 'instagram-comment',
    channelName: 'Instagram',
    platform: 'instagram',
    customerName: 'sevgi_1234',
    userName: 'sevgi_1234',
    postTitle: 'Yeni koleksiyon tanıtımı',
    comment: 'Çok beğendim! Fiyatı ne kadar?',
    timestamp: new Date(Date.now() - 10 * 60000),
    unread: 1,
    replies: [],
  },
  {
    id: 'cm2',
    channelType: 'instagram-comment',
    channelName: 'Instagram',
    platform: 'instagram',
    customerName: 'ahmet_deniz',
    userName: 'ahmet_deniz',
    postTitle: 'İndirim kampanyası duyurusu',
    comment: 'Bu kampanya ne zaman bitiyor?',
    timestamp: new Date(Date.now() - 30 * 60000),
    unread: 1,
    replies: [],
  },
  {
    id: 'cm3',
    channelType: 'facebook-comment',
    channelName: 'Facebook',
    platform: 'facebook',
    customerName: 'Ayşe Yılmaz',
    userName: 'Ayşe Yılmaz',
    postTitle: 'Ürün tanıtımı - Kış koleksiyonu',
    comment: 'Harika görünüyor! Hangi bedenlerde var?',
    timestamp: new Date(Date.now() - 45 * 60000),
    unread: 0,
    replies: [
      {
        id: 'r1',
        sender: 'agent',
        content: 'S, M, L ve XL bedenlerde mevcuttur. Detaylı bilgi için DM atabilirsiniz.',
        timestamp: new Date(Date.now() - 40 * 60000),
      },
    ],
  },
  {
    id: 'cm4',
    channelType: 'facebook-comment',
    channelName: 'Facebook',
    platform: 'facebook',
    customerName: 'Mehmet Kara',
    userName: 'Mehmet Kara',
    postTitle: 'Ücretsiz kargo kampanyası',
    comment: 'Tüm ürünlerde geçerli mi bu kampanya?',
    timestamp: new Date(Date.now() - 60 * 60000),
    unread: 1,
    replies: [],
  },
  {
    id: 'cm5',
    channelType: 'instagram-comment',
    channelName: 'Instagram',
    platform: 'instagram',
    customerName: 'zeynep_style',
    userName: 'zeynep_style',
    postTitle: 'Bahar koleksiyonu',
    comment: '😍😍😍 Muhteşem!',
    timestamp: new Date(Date.now() - 90 * 60000),
    unread: 0,
    replies: [
      {
        id: 'r2',
        sender: 'agent',
        content: 'Teşekkür ederiz! ❤️',
        timestamp: new Date(Date.now() - 85 * 60000),
      },
    ],
  },
];

export const channelStats: ChannelStats[] = [
  { type: 'trendyol-product', name: 'Trendyol', category: 'Ürün Sorusu', count: 24, color: '#F27A00' },
  { type: 'trendyol-order', name: 'Trendyol', category: 'Sipariş Sorusu', count: 18, color: '#F27A00' },
  { type: 'instagram-message', name: 'Instagram', category: 'Gelen Mesaj', count: 32, color: '#E4405F' },
  { type: 'facebook-message', name: 'Facebook', category: 'Gelen Mesaj', count: 21, color: '#1877F2' },
  { type: 'whatsapp', name: 'WhatsApp', category: '+90555 555 55 55', count: 45, color: '#25D366' },
  { type: 'email', name: 'E-posta', category: 'info@test.com', count: 15, color: '#EA4335' },
  { type: 'ticimax', name: 'Ticimax', category: 'Destek Talebi', count: 12, color: '#00A8E8' },
  { type: 'hepsiburada-product', name: 'Hepsiburada', category: 'Ürün Sorusu', count: 19, color: '#FF6000' },
  { type: 'hepsiburada-order', name: 'Hepsiburada', category: 'Sipariş Sorusu', count: 16, color: '#FF6000' },
];

export const commentStats: ChannelStats[] = [
  { type: 'instagram-comment', name: 'Instagram', category: 'Gelen Yorum', count: 48, color: '#E4405F' },
  { type: 'facebook-comment', name: 'Facebook', category: 'Gelen Yorum', count: 35, color: '#1877F2' },
];

// Rol bazlı izin şablonları
export const rolePermissions = {
  admin: {
    dashboard: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    messages: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    comments: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    users: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    settings: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    canUseAI: true,
  },
  moderator: {
    dashboard: { canView: true, canCreate: false, canEdit: false, canDelete: false },
    messages: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    comments: { canView: true, canCreate: true, canEdit: true, canDelete: true },
    users: { canView: true, canCreate: false, canEdit: false, canDelete: false },
    settings: { canView: true, canCreate: false, canEdit: false, canDelete: false },
    canUseAI: true,
  },
  agent: {
    dashboard: { canView: true, canCreate: false, canEdit: false, canDelete: false },
    messages: { canView: true, canCreate: true, canEdit: true, canDelete: false },
    comments: { canView: true, canCreate: true, canEdit: true, canDelete: false },
    users: { canView: false, canCreate: false, canEdit: false, canDelete: false },
    settings: { canView: false, canCreate: false, canEdit: false, canDelete: false },
    canUseAI: true,
  },
} as const;

export const mockUsers: User[] = [
  {
    id: 'u1',
    name: 'Admin Kullanıcı',
    email: 'admin@example.com',
    password: 'admin123', // Demo amaçlı - gerçek sistemde hash'lenmiş olmalı
    role: 'admin',
    status: 'active',
    permissions: rolePermissions.admin,
    lastLogin: new Date(Date.now() - 30 * 60000),
    createdAt: new Date(Date.now() - 365 * 24 * 60 * 60000),
  },
  {
    id: 'u2',
    name: 'Ahmet Yılmaz',
    email: 'ahmet.yilmaz@example.com',
    password: 'moderator123',
    role: 'moderator',
    status: 'active',
    permissions: rolePermissions.moderator,
    lastLogin: new Date(Date.now() - 120 * 60000),
    createdAt: new Date(Date.now() - 180 * 24 * 60 * 60000),
  },
  {
    id: 'u3',
    name: 'Zeynep Demir',
    email: 'zeynep.demir@example.com',
    password: 'agent123',
    role: 'agent',
    status: 'active',
    permissions: rolePermissions.agent,
    lastLogin: new Date(Date.now() - 15 * 60000),
    createdAt: new Date(Date.now() - 90 * 24 * 60 * 60000),
  },
  {
    id: 'u4',
    name: 'Mehmet Kaya',
    email: 'mehmet.kaya@example.com',
    password: 'agent123',
    role: 'agent',
    status: 'active',
    permissions: rolePermissions.agent,
    lastLogin: new Date(Date.now() - 45 * 60000),
    createdAt: new Date(Date.now() - 60 * 24 * 60 * 60000),
  },
  {
    id: 'u5',
    name: 'Ayşe Şahin',
    email: 'ayse.sahin@example.com',
    password: 'agent123',
    role: 'agent',
    status: 'inactive',
    permissions: rolePermissions.agent,
    lastLogin: new Date(Date.now() - 10 * 24 * 60 * 60000),
    createdAt: new Date(Date.now() - 120 * 24 * 60 * 60000),
  },
  {
    id: 'u6',
    name: 'Can Öztürk',
    email: 'can.ozturk@example.com',
    password: 'agent123',
    role: 'agent',
    status: 'active',
    permissions: rolePermissions.agent,
    lastLogin: new Date(Date.now() - 90 * 60000),
    createdAt: new Date(Date.now() - 45 * 24 * 60 * 60000),
  },
  {
    id: 'u7',
    name: 'Elif Yıldız',
    email: 'elif.yildiz@example.com',
    password: 'moderator123',
    role: 'moderator',
    status: 'active',
    permissions: rolePermissions.moderator,
    lastLogin: new Date(Date.now() - 60 * 60000),
    createdAt: new Date(Date.now() - 150 * 24 * 60 * 60000),
  },
  {
    id: 'u8',
    name: 'Ali Demir',
    email: 'ali.demir@example.com',
    password: 'agent123',
    role: 'agent',
    status: 'active',
    permissions: rolePermissions.agent,
    lastLogin: new Date(Date.now() - 5 * 60000),
    createdAt: new Date(Date.now() - 30 * 24 * 60 * 60000),
  },
];