export type UserRole = 'admin' | 'moderator' | 'agent';

export type UserStatus = 'active' | 'inactive';

// Kanal tipleri
export type ChannelType =
  | 'trendyol-product'
  | 'trendyol-order'
  | 'hepsiburada-product'
  | 'hepsiburada-order'
  | 'instagram-message'
  | 'facebook-message'
  | 'whatsapp'
  | 'email'
  | 'ticimax';

// Ürün bilgileri (Trendyol/Hepsiburada ürün soruları için)
export interface ProductInfo {
  imageUrl: string;
  name: string;
  stockCode: string;
  brand: string;
}

// Sipariş bilgileri (Trendyol/Hepsiburada sipariş soruları için)
export interface OrderInfo {
  orderNumber: string;
  orderDate: Date;
}

// Talep bilgileri (Ticimax destek talepleri için)
export interface TicketInfo {
  title: string;
  date: Date;
}

// Mesaj context bilgileri
export interface MessageContext {
  productInfo?: ProductInfo;
  orderInfo?: OrderInfo;
  ticketInfo?: TicketInfo;
}

// Konuşma mesajı
export interface ConversationMessage {
  id: string;
  sender: 'customer' | 'agent';
  content: string;
  timestamp: Date;
}

// Ana mesaj objesi
export interface Message {
  id: string;
  channelType: ChannelType;
  channelName: string;
  channelCategory: string;
  customerName: string;
  lastMessage: string;
  timestamp: Date;
  unread: number;
  conversation: ConversationMessage[];
  context?: MessageContext; // Mesaj bağlamı
  isUrgent?: boolean; // Yöneticiye iletilen acil mesajlar
}

// Yorum objesi
export interface Comment {
  id: string;
  channelType: 'instagram-comment' | 'facebook-comment';
  channelName: string;
  platform: 'instagram' | 'facebook';
  postTitle: string;
  userName: string;
  customerName: string;
  userAvatar?: string;
  comment: string;
  timestamp: Date;
  unread: number;
  status?: 'pending' | 'replied' | 'hidden';
  replies?: {
    id: string;
    content: string;
    timestamp: Date;
    sender: 'agent';
  }[];
}

// Kanal istatistikleri
export interface ChannelStats {
  type: string;
  name: string;
  category: string;
  count: number;
  channel?: string;
  total?: number;
  answered?: number;
  unanswered?: number;
  avgResponseTime?: string;
  color?: string;
}

// Sayfa yetkileri
export interface PagePermissions {
  canView: boolean;
  canCreate: boolean;
  canEdit: boolean;
  canDelete: boolean;
}

// Sayfa bazlı yetkilendirme sistemi
export interface UserPermissions {
  dashboard: PagePermissions;
  messages: PagePermissions;
  comments: PagePermissions;
  users: PagePermissions;
  settings: PagePermissions;
  // AI ve özel yetkiler
  canUseAI: boolean;
}

export interface User {
  id: string;
  name: string;
  email: string;
  password?: string; // Şifre - güvenlik nedeniyle isteğe bağlı
  avatar?: string;
  role: UserRole;
  status: UserStatus;
  permissions: UserPermissions;
  lastLogin?: Date;
  createdAt: Date;
}